% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_APA_model_CI}
\alias{umx_APA_model_CI}
\title{umx_APA_model_CI}
\usage{
umx_APA_model_CI(model, cellLabel, prefix = "top.", suffix = "_std",
  digits = 2, verbose = FALSE)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to get CIs from}

\item{cellLabel}{the label of the cell to interrogate for a CI, e.g. "ai_r1c1"}

\item{prefix}{The submodel to look in (i.e. "top.")}

\item{suffix}{The suffix for algebras ("_std")}

\item{digits}{= 2}

\item{verbose}{= FALSE}
}
\value{
- the CI string, e.g. ".73[-.20,.98]"
}
\description{
Look up CIs for free parameters in a model, and return as APA-formatted text string
}
\examples{
\dontrun{
umx_APA_model_CI(fit_IP, cellLabel = "ai_r1c1", prefix = "top.", suffix = "_std")
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxEval}}, \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umx_APA_pval}},
  \code{\link{umx_aggregate}}, \code{\link{umx_names}},
  \code{\link{umx_parameters}}, \code{\link{umx_print}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
