% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxReduceGxE}
\alias{umxReduceGxE}
\title{Reduce a GxE model.}
\usage{
umxReduceGxE(
  model,
  report = c("markdown", "inline", "html", "report"),
  baseFileName = "tmp_gxe",
  tryHard = c("no", "yes", "mxTryHard", "mxTryHardOrdinal", "mxTryHardWideSearch"),
  ...
)
}
\arguments{
\item{model}{An \code{\link[=mxModel]{mxModel()}} to reduce.}

\item{report}{How to report the results. "html" = open in browser.}

\item{baseFileName}{(optional) custom filename for html output (defaults to "tmp").}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "mxTryHardOrdinal", "mxTryHardWideSearch"}

\item{...}{Other parameters to control model summary.}
}
\value{
best model
}
\description{
This function can perform model reduction for \code{\link[=umxGxE]{umxGxE()}} models,
testing dropping a\verb{,c} & e\verb{, as well as c & c}, a & a` etc.

It reports the results in a table. Set the format of the table with
\code{\link[=umx_set_table_format]{umx_set_table_format()}}. Or set \code{report = "html"} to open a
table for pasting into a word processor.

In addition to printing a table, the function returns the preferred model.
}
\examples{
\dontrun{
model = umxReduce(model)
}
}
\references{
\itemize{
\item Wagenmakers, E.J., & Farrell, S. (2004). AIC model selection using Akaike weights.
\emph{Psychonomic Bulletin and Review}, \strong{11}, 192-196. \href{https://doi.org/10.3758/BF03206482}{doi:}.
}
}
\seealso{
\code{\link[=umxReduceACE]{umxReduceACE()}}, \code{\link[=umxReduce]{umxReduce()}}

Other Twin Reporting Functions: \code{\link{umxPlotCP}()},
  \code{\link{umxReduceACE}()}, \code{\link{umxReduce}()},
  \code{\link{umxSummarizeTwinData}()},
  \code{\link{umxSummaryACEcov}()},
  \code{\link{umxSummaryACEv}()},
  \code{\link{umxSummaryACE}()},
  \code{\link{umxSummaryCP}()},
  \code{\link{umxSummaryGxEbiv}()},
  \code{\link{umxSummaryGxE}()},
  \code{\link{umxSummaryIP}()},
  \code{\link{umxSummarySexLim}()},
  \code{\link{umxSummarySimplex}()}, \code{\link{umx}}
}
\concept{Twin Reporting Functions}
