% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_grep}
\alias{umx_grep}
\title{Search for text}
\usage{
umx_grep(
  df,
  grepString,
  output = c("both", "label", "name"),
  ignore.case = TRUE,
  useNames = FALSE
)
}
\arguments{
\item{df}{The \code{\link[=data.frame]{data.frame()}} or string to search.}

\item{grepString}{the search string.}

\item{output}{the column name, the label, or both (default).}

\item{ignore.case}{whether to be case sensitive or not (default TRUE = ignore case).}

\item{useNames}{whether to search the names as well as the labels (for SPSS files with label metadata).}
}
\value{
\itemize{
\item list of matched column names and/or labels.
}
}
\description{
Search names if given a data.frame, or strings if given a vector of strings.
}
\details{
The \code{namez} function is more flexible. A handy feature of \code{umx_grep} is that it can
search the labels of data imported from SPSS.

\emph{nb:} To simply grep for a pattern in a string use R's built-in \code{\link[=grep]{grep()}} functions, e.g.:
\verb{grepl("^NA\\\[0-9]", "NA.3")}
}
\examples{
umx_grep(mtcars, "hp", output="both", ignore.case= TRUE)
umx_grep(c("hp", "ph"), "hp")
umx_grep(mtcars, "^h.*", output="both", ignore.case= TRUE)
\dontrun{
umx_grep(spss_df, "labeltext", output = "label") 
umx_grep(spss_df, "labeltext", output = "name") 
}
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=namez]{namez()}}, \code{\link[=umx_aggregate]{umx_aggregate()}}, \code{\link[=grep]{grep()}}
}

Other String Functions: \code{\link{umx_explode_twin_names}()},
  \code{\link{umx_explode}()}, \code{\link{umx_names}()},
  \code{\link{umx_object_as_str}()},
  \code{\link{umx_paste_names}()}, \code{\link{umx_rot}()},
  \code{\link{umx_trim}()},
  \code{\link{umx_write_to_clipboard}()}, \code{\link{umx}}
}
\concept{String Functions}
