% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_move_file}
\alias{umx_move_file}
\title{Move files}
\usage{
umx_move_file(
  baseFolder = NA,
  regex = NULL,
  fileNameList = NA,
  destFolder = NA,
  test = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{baseFolder}{The folder to search in. If set to "Finder" (and you are on OS X) it will use the current
front-most Finder window. If it is blank, a choose folder dialog will be thrown.}

\item{regex}{string to select files to process within the selected folder.}

\item{fileNameList}{List of files to move.}

\item{destFolder}{Folder to move files to.}

\item{test}{Boolean determining whether to change the names, or just report a dry run.}

\item{overwrite}{Boolean determining whether to overwrite files or not (default = FALSE (safe)).}
}
\value{
None
}
\description{
On OS X, \code{umx_move_file} can access the current front-most Finder window.
The file moves are fast and, because you can use regular expressions, powerful.
}
\examples{
\dontrun{
base = "~/Desktop/"
dest = "~/Music/iTunes/iTunes Music/Music/"
umx_move_file(baseFolder = base, fileNameList = toMove, destFolder = dest, test= TRUE)

# ============================================================
# = Move all files in downloads ending in ".jpeg" to Desktop =
# ============================================================
umx_move_file(baseFolder = "~/Downloads/", regex=".jpeg", 
	destFolder = "~/Desktop/", test= TRUE)
}

}
\seealso{
\code{\link[=file.rename]{file.rename()}}, \code{\link[=regex]{regex()}}

Other File Functions: 
\code{\link{dl_from_dropbox}()},
\code{\link{umx_file_load_pseudo}()},
\code{\link{umx_make_sql_from_excel}()},
\code{\link{umx_open}()},
\code{\link{umx_rename_file}()},
\code{\link{umx_write_to_clipboard}()},
\code{\link{umx}}
}
\concept{File Functions}
