% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umxVersion}
\alias{umxVersion}
\title{Get or print the version of umx, along with detail from OpenMx and general system info.}
\usage{
umxVersion(
  model = NULL,
  min = NULL,
  verbose = TRUE,
  return = c("umx_vers", "OpenMx_vers")
)
}
\arguments{
\item{model}{Optional to show optimizer in this model}

\item{min}{Optional minimum version string to test for, e.g. '2.7.0' (Default = NULL).}

\item{verbose}{= TRUE}

\item{return}{Which package (umx or OpenMx) to 'return' version info for (Default = umx).}
}
\value{
\itemize{
\item \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}
}
}
\description{
umxVersion returns the version information for umx, and for OpenMx and R.
Essential for bug-reports! This function can also test for a minimum version.
}
\examples{
x = umxVersion(); x
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=packageVersion]{packageVersion()}}, \code{\link[=install.OpenMx]{install.OpenMx()}}
}

Other Miscellaneous Utility Functions: 
\code{\link{install.OpenMx}()},
\code{\link{libs}()},
\code{\link{qm}()},
\code{\link{umx}},
\code{\link{umxLav2RAM}()},
\code{\link{umxModelNames}()},
\code{\link{umxRAM2Lav}()},
\code{\link{umx_array_shift}()},
\code{\link{umx_find_object}()},
\code{\link{umx_lower.tri}()},
\code{\link{umx_msg}()},
\code{\link{umx_open_CRAN_page}()},
\code{\link{umx_pad}()},
\code{\link{umx_print}()}
}
\concept{Miscellaneous Utility Functions}
