% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxGetLatents}
\alias{umxGetLatents}
\title{Get the latentVars from a RAM model}
\usage{
umxGetLatents(model, targetModel = NULL)
}
\arguments{
\item{model}{a \code{\link[=umxRAM]{umxRAM()}}}

\item{targetModel}{name of the model to extract from}
}
\value{
\itemize{
\item variables
}
}
\description{
Get the latentVars from a RAM model, optionally targeting a submodel.
}
\examples{
\dontrun{
library(umx)
# Create two sets of data in which X & Y correlate ~ .4 in both datasets.
manifests = c("x", "y")
tmp = umx_make_TwinData(nMZpairs = 100, nDZpairs = 150, 
		AA = 0, CC = .4, EE = .6, varNames = manifests)

grp1   = tmp[tmp$zygosity == "MZ", manifests]
g1Data = mxData(cov(grp1), type = "cov", numObs = nrow(grp1), means=umx_means(grp1))

grp2   = tmp[tmp$zygosity == "DZ", manifests]
g2Data = mxData(cov(grp2), type = "cov", numObs = nrow(grp2), means=umx_means(grp2))
# Model 1 (could add autoRun = FALSE if you don't want to run this as it is being built)
m1 = umxRAM("m1", data = g1Data,
	umxPath("x", to = "y", labels = "beta"),
	umxPath(var = manifests, labels = c("Var_x", "Resid_y_grp1")),
	umxPath(means = manifests, labels = c("Mean_x", "Mean_y"))
)

# Model 2
m2 = umxRAM("m2", data = g2Data,
	umxPath("x", to = "y", labels = "beta"),
	umxPath(var = manifests, labels=c("Var_x", "Resid_y_grp2")),
	umxPath(means = manifests, labels=c("Mean_x", "Mean_y"))
)

m3 = umxSuperModel('top', m1, m2)
umxGetLatents(m3)
umxGetLatents(m3, targetModel = "m1")
}
}
\seealso{
\itemize{
\item \code{\link[=umxGetManifests]{umxGetManifests()}}, \code{\link[=umxRAM]{umxRAM()}}, \code{\link[=umxSuperModel]{umxSuperModel()}}
}

Other Reporting Functions: 
\code{\link{umx}},
\code{\link{umxAPA}()},
\code{\link{umxFactorScores}()},
\code{\link{umxGetManifests}()},
\code{\link{umxGetModel}()},
\code{\link{umxGetParameters}()},
\code{\link{umxParameters}()},
\code{\link{umx_aggregate}()},
\code{\link{umx_time}()}
}
\concept{Reporting Functions}
