% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dublin.R
\docType{data}
\name{trinity_2}
\alias{trinity_2}
\title{Secondary colors of Trinity College Dublin, Ireland}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on 
\href{https://www.tcd.ie/identity/colour-palette/}{TCD's website}.
}
\usage{
trinity_2
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{trinity_2} provides the 57 secondary colors 
of the \href{https://www.tcd.ie}{Trinity College Dublin}, Ireland.
}
\details{
The 57 secondary colors are 
\code{"pms_312_100"} (defined as HEX #12312b),
\code{"pms_312_75"} (defined as HEX #0D1E1C),
\code{"pms_312_50"} (defined as HEX #ffffff),
\code{"pms_312_25"} (defined as HEX #000000), 
\code{"pms_312_10"} (defined as HEX #f7f7f7), 
\code{"pms_326_100"} (defined as HEX #e2e2e2), 
\code{"pms_326_75"} (defined as HEX #707070), 
\code{"pms_326_50"} (defined as HEX #424141), 
\code{"pms_326_25"} (defined as HEX #12312b),
\code{"pms_326_10"} (defined as HEX #0D1E1C),
\code{"pms_360_100"} (defined as HEX #ffffff),
\code{"pms_360_75"} (defined as HEX #000000), 
\code{"pms_360_50"} (defined as HEX #f7f7f7), 
\code{"pms_360_25"} (defined as HEX #e2e2e2), 
\code{"pms_360_10"} (defined as HEX #707070), 
\code{"pms_375_100"} (defined as HEX #424141),
\code{"pms_375_100"} (defined as HEX #12312b),
\code{"pms_375_75"} (defined as HEX #0D1E1C),
\code{"pms_375_50"} (defined as HEX #ffffff),
\code{"pms_375_25"} (defined as HEX #000000), 
\code{"pms_375_10"} (defined as HEX #f7f7f7), 
\code{"web_gray_2"} (defined as HEX #e2e2e2), 
\code{"web_gray_3"} (defined as HEX #707070), 
\code{"granite_gray"} (defined as HEX #424141), 
\code{"forest_green"} (defined as HEX #12312b),
\code{"rich_forest_green"} (defined as HEX #0D1E1C),
\code{"snow_white"} (defined as HEX #ffffff),
\code{"midnight_black"} (defined as HEX #000000), 
\code{"web_gray_1"} (defined as HEX #f7f7f7), 
\code{"web_gray_2"} (defined as HEX #e2e2e2), 
\code{"web_gray_3"} (defined as HEX #707070), 
\code{"granite_gray"} (defined as HEX #424141), 
\code{"forest_green"} (defined as HEX #12312b),
\code{"rich_forest_green"} (defined as HEX #0D1E1C),
\code{"snow_white"} (defined as HEX #ffffff),
\code{"midnight_black"} (defined as HEX #000000), 
\code{"web_gray_1"} (defined as HEX #f7f7f7), 
\code{"web_gray_2"} (defined as HEX #e2e2e2), 
\code{"web_gray_3"} (defined as HEX #707070), 
\code{"granite_gray"} (defined as HEX #424141), 
\code{"forest_green"} (defined as HEX #12312b),
\code{"rich_forest_green"} (defined as HEX #0D1E1C),
\code{"snow_white"} (defined as HEX #ffffff),
\code{"midnight_black"} (defined as HEX #000000), 
\code{"web_gray_1"} (defined as HEX #f7f7f7), 
\code{"web_gray_2"} (defined as HEX #e2e2e2), 
\code{"web_gray_3"} (defined as HEX #707070), 
\code{"granite_gray"} (defined as HEX #424141), 
\code{"forest_green"} (defined as HEX #12312b),
\code{"rich_forest_green"} (defined as HEX #0D1E1C),
\code{"snow_white"} (defined as HEX #ffffff),
\code{"midnight_black"} (defined as HEX #000000), 
\code{"web_gray_1"} (defined as HEX #f7f7f7), 
\code{"web_gray_2"} (defined as HEX #e2e2e2), 
\code{"web_gray_3"} (defined as HEX #707070), 
\code{"granite_gray"} (defined as HEX #424141), and 
\code{"granite_gray"} (defined as HEX #424141).

\code{trinity_2} uses the HEX color definitions.
}
\examples{
trinity_2
unikn::seecol(trinity_2, main = "Trinity College Dublin 2") # view color palette

}
\seealso{
\code{\link{trinity_1}} for primary colors of Trinity College Dublin; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes.: 
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{limerick_2}},
\code{\link{notredame_2}},
\code{\link{uci_2}},
\code{\link{uflorida_2}},
\code{\link{vanderbilt_2}}
}
\author{
\strong{unicol}, 2023-07-07.
}
\concept{university color palettes.}
\keyword{datasets}
