% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Caltech.R
\docType{data}
\name{caltech_3}
\alias{caltech_3}
\title{Primary and bright colors of Caltech, USA}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on 
\url{https://identity.caltech.edu/colors}.
}
\usage{
caltech_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{caltech_3} provides the primary and 7 bright colors 
of the \href{https://www.caltech.edu/}{California Institute of Technology}, CA, USA.
}
\details{
Caltech's primary orange color is defined as \code{Pantone MS 1585c}  
(for coated and matte print jobs, \code{PMS 151} for uncoated print jobs). 
Use this color for small highlights, rather than large areas. 

Caltech's 7 bright colors provide an opportunity to adjust the temper 
of communication materials from subtle to bold. 
These colors should be used as carefully selected accents 
to the primary, neutral, and deep colors 
(of \code{\link{caltech_1}} and \code{\link{caltech_2}}).
}
\examples{
caltech_3
unikn::seecol(caltech_3, main = "Primary and bright colors of Caltech")
unikn::demopal(caltech_3, type = 3, seed = 1,  
               main = "Using the primary and bright colors of Caltech")

}
\seealso{
\code{\link{caltech_1}} for Caltech's primary and neutral colors; 
\code{\link{caltech_2}} for Caltech's primary and deep colors; 
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2022-10-28.
}
\concept{U.S. university color palettes}
\keyword{datasets}
