% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lancaster.R
\docType{data}
\name{lancaster_1}
\alias{lancaster_1}
\title{Primary colours of the Lancaster University, England, UK}
\format{
An object of class \code{character} of length 3.
}
\source{
Colour definitions are based on 
\href{https://www.lancaster.ac.uk/media/lancaster-university/content-assets/documents/current-staff/brand/LUBrandGuidelines-Staff-Nov-2018.pdf}{Lancaster's Primary guide (PDF)}.
}
\usage{
lancaster_1
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{lancaster_1} provides the three Primary colours 
of \href{https://www.lancaster.ac.uk}{Lancaster University}, England, UK.
}
\details{
The three primary colours of \href{https://www.lancaster.ac.uk}{Lancaster University} are
\code{"Pantone 1807"} (defined as HEX: #b5121b)
\code{"Pantone 429"} (defined as HEX: #bec0c2), and
\code{"Pantone 432"} (defined as HEX: #555656).

\code{lancaster_1} uses the HEX colour definitions.
}
\examples{
lancaster_1
unikn::seecol(lancaster_1, main = "Primary colours of Lancaster University", col_bg = "white") 
# view colour palette

}
\seealso{
\code{\link{lancaster_2}} for secondary colours of Lancaster University;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-07-04.
}
\concept{English university color palettes}
\keyword{datasets}
