% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unigd.R
\name{ugd_render}
\alias{ugd_render}
\title{Render unigd plot and return it.}
\usage{
ugd_render(
  page = 0,
  width = -1,
  height = -1,
  zoom = 1,
  as = "svg",
  which = dev.cur()
)
}
\arguments{
\item{page}{Plot page to render. If this is set to \code{0}, the last page will
be selected. Can be set to a numeric plot index or plot ID
(see \code{\link[=ugd_id]{ugd_id()}}).}

\item{width}{Width of the plot. If this is set to \code{-1}, the last width will
be selected.}

\item{height}{Height of the plot. If this is set to \code{-1}, the last height
will be selected.}

\item{zoom}{Zoom level. (For example: \code{2} corresponds to 200\%, \code{0.5} would
be 50\%.)}

\item{as}{Renderer.}

\item{which}{Which device (ID).}
}
\value{
Rendered plot. Text renderers return strings, binary renderers
return byte arrays.
}
\description{
See \code{\link[=ugd_save]{ugd_save()}} for saving rendered plots as files.
This function will only work after starting a device with \code{\link[=ugd]{ugd()}}.
}
\examples{
ugd()
plot(1, 1)
ugd_render(width = 600, height = 400, as = "svg")
dev.off()
}
