% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/justify.R
\name{justify}
\alias{justify}
\title{Align one set of cells with another set}
\usage{
justify(header_cells, corner_cells)
}
\arguments{
\item{header_cells}{Data frame of data cells with at least the columns 'row'
and 'column', which are \code{numeric} or \code{integer}.}

\item{corner_cells}{Data frame of header cells with at least the columns
'row' and 'column', which are numeric/integer vectors.  The same length as
\code{header_cells}.}
}
\description{
If the header cells of a table aren't aligned to the left, right, top or
bottom of the data cells that they describe, then use \code{\link[=justify]{justify()}} to re-align
them, using a second set of cells as a guide.
}
\examples{
header_cells <- tibble::tibble(row = c(1L, 1L, 1L, 1L),
                               col = c(3L, 5L, 8L, 10L),
                               value = LETTERS[1:4])
corner_cells <- tibble::tibble(row = c(2L, 2L, 2L, 2L),
                               col = c(1L, 4L, 6L, 9L))
justify(header_cells, corner_cells)
}
