% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unstruwwel.R
\name{unstruwwel}
\alias{unstruwwel}
\title{Detect and Parse Historic Dates}
\usage{
unstruwwel(
  x,
  language = NULL,
  verbose = TRUE,
  scheme = "time-span",
  fuzzify = c(0, 0)
)
}
\arguments{
\item{x}{Input vector. Either a character vector, or something
coercible to one.}

\item{language}{Language code of the input vector as defined in
ISO 639-1. If \code{NULL}, language is detected automatically.}

\item{verbose}{If \code{TRUE}, additional diagnostics are printed.}

\item{scheme}{Scheme code of the output list. Either \code{time-span},
\code{iso-format}, or \code{object}.}

\item{fuzzify}{A numerical vector of length 2 to extend the interval
of approximate or uncertain time periods. This is only applied if
\code{scheme == "time-span"}.}
}
\value{
A named list of vectors or objects of \code{\link{R6Class}}.
}
\description{
Detect and Parse Historic Dates, e.g., to ISO 8601:2-2019.
}
\note{
Although multiple languages can be detected, only dominant
ones are ultimately set.
}
\examples{
if (interactive()) {
unstruwwel("1. Hälfte 19. Jahrhundert", language = "de")
unstruwwel("circa between 1901 and 1905", language = "en")
}

}
