% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upmbuilder.R
\name{upmbuilder}
\alias{upmbuilder}
\title{Bayesian Markov Chain Monte Carlo model building for household-community tuberculosis transmission models}
\usage{
upmbuilder(design.matrix, categorical.columns = 0, prior.beta.means = rep(x
  = 0, times = ncol(design.matrix[, which(names(design.matrix) != "cluster")])),
  prior.beta.sd = rep(x = 3.162278, times = ncol(design.matrix[,
  which(names(design.matrix) != "cluster")])), prior.alpha = c(0, 0.44))
}
\arguments{
\item{design.matrix}{A data frame type design matrix of observations for rows, variables on each observation for columns. If there are natural clusters (households), then a variable titled 'cluster' must be included. The design matrix must have exactly one column titled 'y' for outcome on each observation.}

\item{categorical.columns}{A scalar (vector) specification of any column(s) of type "factor" to be coded as a dummy variable regression. Default is 0: no columns are factor variables.}

\item{prior.beta.means}{A scalar (vector) specification of Gaussian prior distirbution mean(s) for the coefficient(s) in the household component of the logistic regression model. Default is noninformative on the inverse logit transformed (odds ratio) scale.}

\item{prior.beta.sd}{A scalar (vector) specification of Gaussian prior distirbution standard deviation(s) for the coefficient(s) in the household component of the logistic regression model.  Default is noninformative on the inverse logit transformed (odds ratio) scale.}

\item{prior.alpha}{A vector of prior probability parameters for the alpha term in the community component of model, a logistic regression with intercept only. Default is noninformative, with p^C being essentially uniform on the unit interval.}
}
\value{
A list of: a JAGS model script for specification of the unified probability model to be used; the (possibly recoded) design matrix; a vector of the beta coefficient names to be used in the household component of the UPM.
}
\description{
Bayesian Markov Chain Monte Carlo model building for household-community tuberculosis transmission models
}
\details{
The package contains long-form documentation in the form of a vignette that cover the use of the main fucntions. Use browseVignettes(package="upmfit") to access them.
}
\examples{
upmbuilder(design.matrix=upmdata)

upmbuilder(design.matrix=upmdata, prior.alpha=c(-2.2,round(1/sqrt(3),3)))
suppressWarnings(cat(upmbuilder(design.matrix=upmdata,
prior.alpha=c(-2.2,round(1/sqrt(3),3)))[[1]]))

}
