% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_groups.R
\name{bitly_retrieve_group_pref}
\alias{bitly_retrieve_group_pref}
\title{Retrieve Group Preferences}
\usage{
bitly_retrieve_group_pref(group_id = NA, showRequestURL = F)
}
\arguments{
\item{group_id}{- the group id the user belongs to}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been
build and requested from server. For debug purposes, default FALSE.}
}
\description{
Retrieve preferences for a specific group
}
\section{Group}{

Groups are a subdivision within an organization. A user will belong to a group within an organization.
Most actions on our API will be on behalf of a group. For example, when you
shorten a link, it will be on behalf of a user and a group.
}

\examples{
\dontrun{
ui <- bitly_user_info(showRequestURL = TRUE)
group_pref <- bitly_retrieve_group_pref(group_id = ui$default_group_guid[1])
}
}
\seealso{
\url{https://dev.bitly.com/v4/#operation/getGroupPreferences}
}
