% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.r
\name{simple.impute}
\alias{simple.impute}
\title{simple.impute}
\usage{
simple.impute(x, fun = median, ...)
}
\arguments{
\item{x}{An object to be imputed}

\item{fun}{The function with which to fill in missing values}

\item{\dots}{Further arguments}
}
\value{
An object with the missing values imputed.
}
\description{
Generic function for simple imputation.
}
\details{
Provides the ability to simply impute data based on a simple measure such as mean or median.  For more robust imputation see the packages Amelia, mice or mi.
}
\examples{
theDF <- data.frame(A=1:10, B=1:10, C=1:10)
theDF[c(1, 4, 6), c(1)] <- NA
theDF[c(3, 4, 8), c(3)] <- NA

simple.impute(theDF$A)
simple.impute(theDF$A, mean)
simple.impute(theDF$A, constant(4))
simple.impute(theDF)
simple.impute(theDF, mean)
simple.impute(theDF, constant(4))

}
\author{
Jared P. Lander
}

