% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.r
\name{multiple.identity}
\alias{multiple.identity}
\title{multiple.identity}
\usage{
multiple.identity(x, ...)
}
\arguments{
\item{x}{Vector of numbers to be formatted.}

\item{\dots}{Further arguments to be passed on to \code{link{multiple}}}
}
\value{
Character vector of formatted numbers.
}
\description{
Order of Magnitude Formatter
}
\details{
Simply a wrapper for multiple that prespecifies the extra identity.
}
\examples{

vect <- c(1000, 1500, 23450, 21784, 875003780)
multiple.identity(vect)
multiple.identity(vect, multiple="k")
multiple.identity(vect, multiple="h")

require(ggplot2)
data(diamonds)
ggplot(diamonds, aes(x=x, y=y, color=price*100)) + geom_point() + 
scale_color_gradient2(labels=multiple.identity)

}
\author{
Jared P. Lander
}
