\name{ggqq}
\alias{ggqq}
\title{
Easy ggplot Q-Q plot
}
\description{
This function creates a qq-plot with a confidence interval.
}
\usage{
ggqq(x, distribution = "norm", ...,
     ci = TRUE, line.estimate = NULL,
     conf.level = 0.95,
     sampleSizeOverride = NULL,
     xlab = "Theoretical quantiles",
     ylab = "Observed quantiles",
     theme = theme_bw())
}
\arguments{
  \item{x}{
  A vector containing the values to plot.
}
  \item{distribution}{
  The distribution to (a 'd' and 'q' are prepended, and the resulting functions are used, e.g. \code{\link{dnorm}} and \code{\link{qnorm}} for the normal curve).
}
  \item{\dots}{
  Any additional arguments are passed to the quantile function (e.g. \code{\link{qnorm}}). Because of these dots, any following arguments must be named explicitly.
}
  \item{ci}{
  Whether to show the confidence interval.
}
  \item{line.estimate}{
  Whether to show the line showing the match with the specified distribution (e.g. the normal distribution).
}
  \item{conf.level}{
  THe confidence of the confidence leven arround the estimate for the specified distribtion.
}
  \item{sampleSizeOverride}{
  It can be desirable to get the confidence intervals for a different sample size (when the sample size is very large, for example, such as when this plot is generated by the function \code{\link{normalityAssessment}}). That different sample size can be specified here.
}
  \item{xlab}{
  The label for the X axis.
}
  \item{ylab}{
  The label for the Y axis.
}
  \item{theme}{
  The theme to use.
}
}
\details{
This is strongly based on the answer by user Floo0 to a Stack Overflow question at Stack Exchange (see \url{http://stackoverflow.com/questions/4357031/qqnorm-and-qqline-in-ggplot2/27191036#27191036}), also posted at GitHub (see \url{https://gist.github.com/rentrop/d39a8406ad8af2a1066c}). That code is in turn based on the \code{\link{qqPlot}} function from the \code{\link{car}} package.
}
\value{
A \code{\link{ggplot}} plot is returned.
}
\author{
John Fox and Floo0; implemented in this package (and tweaked a bit) by Gjalt-Jorn Peters.

Maintainer: Gjalt-Jorn Peters <gjalt-jorn@userfriendlyscience.com>
}
\examples{
ggqq(mtcars$mpg);
}
\keyword{ hplot }
