% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{use_tidy_thanks}
\alias{use_tidy_thanks}
\title{Identify contributors via GitHub activity}
\usage{
use_tidy_thanks(
  repo_spec = github_repo_spec(),
  from = releases(repo_spec)[[1]],
  to = NULL
)
}
\arguments{
\item{repo_spec}{GitHub repo specification in this form: \code{owner/repo}.
Default is to infer from Git remotes of active project.}

\item{from, to}{GitHub ref (i.e., a SHA, tag, or release) or a timestamp in
ISO 8601 format, specifying the start or end of the interval of interest.
Examples: "08a560d", "v1.3.0", "2018-02-24T00:13:45Z", "2018-05-01". \code{NULL}
means there is no bound on that end of the interval.}
}
\value{
A character vector of GitHub usernames, invisibly.
}
\description{
Derives a list of GitHub usernames, based on who has opened issues or pull
requests. Used to populate the acknowledgment section of package release blog
posts at \url{https://www.tidyverse.org/articles/}. All arguments can potentially
be determined from the active project, if the project follows standard
practices around the GitHub remote and GitHub releases. Unexported helper
functions, \code{releases()} and \code{ref_df()} can be useful interactively to get a
quick look at release tag names and a data frame about refs (defaulting to
releases), respectively.
}
\examples{
\dontrun{
## active project, interval = since the last release
use_tidy_thanks()

## active project, interval = since a specific datetime
use_tidy_thanks(from = "2018-02-24T00:13:45Z")

## r-lib/usethis, inteval = since a certain date
use_tidy_thanks("r-lib/usethis", from = "2018-05-01")

## r-lib/usethis, up to a specific release
use_tidy_thanks("r-lib/usethis", from = NULL, to = "v1.3.0")

## r-lib/usethis, since a specific commit, up to a specific date
use_tidy_thanks("r-lib/usethis", from = "08a560d", to = "2018-05-14")
}
}
