% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_taxes.R
\name{create_dataset_for_taxsim}
\alias{create_dataset_for_taxsim}
\title{Convert a data frame to the TAXSIM 35 output.}
\usage{
create_dataset_for_taxsim(.data)
}
\arguments{
\item{.data}{Data frame containing the information that will be used to calculate taxes.
This data set will be sent to TAXSIM. Data frame must have specified column names and data types.}
}
\value{
A data frame that that can be manually uploaded to \href{http://taxsim.nber.org/taxsim35/}{TAXSIM 35}.
}
\description{
This function takes a data set that is in the format required for \code{\link{taxsim_calculate_taxes}},
checks it to make sure it is in the proper format for TAXSIM 35, and then cleans so it can be sent to TAXSIM 35.
This function is useful for troubleshooting. It is not needed to calculate taxes. The function is useful
if you continue receiving unreasonable errors from \code{\link{taxsim_calculate_taxes}}. In such as case,
you can run this function on your data set. You should then save the resulting
data frame as a csv file. Then, upload the file to \href{http://taxsim.nber.org/taxsim35/}{TAXSIM 35}.
}
\details{
\code{\link{create_dataset_for_taxsim}} takes the same columns as column names as \href{http://taxsim.nber.org/taxsim35/}{TAXSIM 35}.
}
\examples{

family_income <- data.frame(
    taxsimid = c(1, 2),
    state = c('North Carolina', 'NY'),
    year = c(2015, 2015),
    mstat = c('single', 'married, jointly'),
    pwages = c(10000, 100000),
    page = c(26, 36)
)

family_taxes <- create_dataset_for_taxsim(family_income)


}
