% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join-data.R
\name{map_with_data}
\alias{map_with_data}
\title{Join county or state level data to US map data}
\usage{
map_with_data(data, values = "values", include = c(), na = NA)
}
\arguments{
\item{data}{The data that should be joined to a US map. This
parameter should be a data frame consisting of two columns,
a fips code (2 characters for state, 5 characters for county)
and the value that should be associated with that region. The
columns of \code{data} \emph{must} be \code{fips} or \code{state} and
the value of the `values` parameter. If both \code{fips} and \code{state}
are provided, this function uses the \code{fips}.}

\item{values}{The name of the column that contains the values to be associated
with a given region. The default is \code{"values"}.}

\item{include}{The regions to include in the output data frame. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or FIPS code.
For counties, the FIPS must be provided as there can be multiple counties with the
same name.}

\item{na}{The value to be inserted for states or counties that don't have
a value in \code{data}. This value must be of the same type as the \code{value}
column of \code{data}.}
}
\value{
A data frame composed of the map data frame (from \code{\link{us_map}}) except
  an extra column containing the values in \code{data} is included.

  The result can be plotted using \code{ggplot2}. See \code{\link{us_map}} for more details.
}
\description{
Join county or state level data to US map data
}
\examples{
state_data <- data.frame(fips = c("01", "02", "04"), values = c(1, 5, 8))
df <- map_with_data(state_data, na = 0)

state_data <- data.frame(state = c("AK", "CA", "Utah"), values = c(6, 9, 3))
df <- map_with_data(state_data, na = 0)

}
