% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/us-map.R
\name{centroid_labels}
\alias{centroid_labels}
\title{Retrieve centroid labels}
\usage{
centroid_labels(
  regions = c("states", "state", "counties", "county"),
  as_sf = TRUE,
  data_year = NULL
)
}
\arguments{
\item{regions}{The region breakdown for the map, can be one of
(\code{"states"}, \code{"state"}, \code{"counties"}, \code{"county"}).
The default is \code{"states"}.}

\item{as_sf}{Defunct, this parameter no longer has any effect and will be removed in
the future.}

\item{data_year}{The year for which to obtain map data.
If the value is \code{NULL}, the most recent year's data is used. If the
provided year is not found from the available map data sets, the next most
recent year's data is used. This can be used if an older data set is being
plotted on the US map so that the data matches the map more accurately.
Therefore, the provided value should match the year of the plotted data set.
The default is \code{NULL}, i.e. the most recent available year is used.}
}
\value{
An \code{sf} data frame of state or county centroid labels and positions
relative to the coordinates returned by the \code{us_map} function.
}
\description{
Retrieve centroid labels
}
