% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{paste_freq}
\alias{paste_freq}
\title{Paste Frequency}
\usage{
paste_freq(num = NA, den = NA, percent.sign = TRUE, digits = 1)
}
\arguments{
\item{num}{Optional. Tibble, Numeric, or Non-Numeric. The numerator.
Tibbles and non-numeric data are automatically tallied (nrow or length).}

\item{den}{Optional. Tibble, Numeric, or Non-Numeric. The denominator.
Tibbles and non-numeric data are automatically tallied (nrow or length). May use
a single denominator for multiple numerators or one denominator for each
numerator.}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round to. Defaults to 1.}
}
\description{
Returns a human-readable frequency from count(able) data. Supports
vectorized data (i.e. dplyr::mutate()).
}
\examples{
library(tibble)

# Numeric
paste_freq(20, 100)

# Tibble
data_tibble <- tibble(column = c(1:100))
paste_freq(data_tibble[1:20,], data_tibble)

# Mixed data types
paste_freq(20, data_tibble)

# Single denominator for multiple numerators
paste_freq(c(10,20,30), 100)
}
