% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calc_duration}
\alias{calc_duration}
\title{Calculate durations of time}
\usage{
calc_duration(x, y, units = NULL)
}
\arguments{
\item{x}{A date or datetime. The start date(s)/timestamp(s).}

\item{y}{A date or datetime. The end date(s)/timestamp(s).}

\item{units}{A character. Units of the returned duration
(i.e. 'seconds', 'days', 'years').}
}
\value{
If 'units' specified, returns numeric. If 'units' unspecified,
returns an object of class '\code{\link[lubridate:Duration-class]{Duration}}'.
}
\description{
Calculates the duration of time between two provided date objects.
Supports vectorized data (i.e. \code{\link[dplyr:mutate]{dplyr::mutate()}}).
}
\note{
Supports multiple calculations against a single time point (i.e.
multiple start dates with a single end date). Note that start and end
must otherwise be of the same length.

When the start and end dates are of different types (i.e. x = date,
y = datetime), a lossy cast will be performed which strips the datetime data
of its time components. This is done to avoid an assumption of more time
passing that would otherwise come with casting the date data to datetime.
}
\examples{
library(lubridate)
library(purrr)

# Dates -> duration in years
calc_duration(
  x = mdy(map_chr(sample(1:9, 5), ~ paste0('01/01/199', .x))),
  y = mdy(map_chr(sample(1:9, 5), ~ paste0('01/01/200', .x))),
  units = 'years'
)

# datetimes -> durations
calc_duration(
  x = mdy_hm(map_chr(sample(1:9, 5), ~ paste0('01/01/199', .x, ' 1', .x, ':00'))),
  y = mdy_hm(map_chr(sample(1:9, 5), ~ paste0('01/01/200', .x, ' 0', .x, ':00')))
)

# Mixed date classes -> durations
calc_duration(
  x = mdy(map_chr(sample(1:9, 5), ~ paste0('01/01/199', .x))),
  y = mdy_hm(map_chr(sample(1:9, 5), ~ paste0('01/01/200', .x, ' 0', .x, ':00')))
)
}
