% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_lp.R
\name{lp}
\alias{lp}
\title{Label Powerset for multi-label Classification}
\usage{
lp(mdata, base.algorithm = getOption("utiml.base.algorithm", "SVM"), ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{...}{Others arguments passed to the base algorithm for all subproblems}

\item{cores}{Not used}

\item{seed}{An optional integer used to set the seed. (Default:
\code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{LPmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{model}{A multi-class model.}
  }
}
\description{
Create a Label Powerset model for multilabel classification.
}
\details{
Label Powerset is a simple transformation method to predict multi-label data.
This is based on the multi-class approach to build a model where the classes
are each labelset.
}
\examples{
model <- lp(toyml, "RANDOM")
pred <- predict(model, toyml)
}
\references{
Boutell, M. R., Luo, J., Shen, X., & Brown, C. M. (2004). Learning
   multi-label scene classification. Pattern Recognition, 37(9), 1757-1771.
}
\seealso{
Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{ctrl}}, \code{\link{dbr}}, \code{\link{ebr}},
  \code{\link{ecc}}, \code{\link{eps}},
  \code{\link{homer}}, \code{\link{lift}},
  \code{\link{mbr}}, \code{\link{ns}}, \code{\link{ppt}},
  \code{\link{prudent}}, \code{\link{ps}},
  \code{\link{rakel}}, \code{\link{rdbr}},
  \code{\link{rpc}}

Other Powerset: \code{\link{eps}}, \code{\link{ppt}},
  \code{\link{ps}}, \code{\link{rakel}}
}
