% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_rpc.R
\name{rpc}
\alias{rpc}
\title{Ranking by Pairwise Comparison (RPC) for multi-label Classification}
\usage{
rpc(mdata, base.algorithm = getOption("utiml.base.algorithm", "SVM"), ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{...}{Others arguments passed to the base algorithm for all subproblems}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{RPCmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{models}{A list of the generated models, named by the label names.}
  }
}
\description{
Create a RPC model for multilabel classification.
}
\details{
RPC is a simple transformation method that uses pairwise classification to
predict multi-label data. This is based on the one-versus-one approach to
build a specific model for each label combination.
}
\examples{
model <- rpc(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
}
}
\references{
Hullermeier, E., Furnkranz, J., Cheng, W., & Brinker, K. (2008).
 Label ranking by learning pairwise preferences. Artificial Intelligence,
 172(16-17), 1897-1916.
}
\seealso{
Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{ctrl}}, \code{\link{dbr}}, \code{\link{ebr}},
  \code{\link{ecc}}, \code{\link{eps}},
  \code{\link{homer}}, \code{\link{lift}},
  \code{\link{lp}}, \code{\link{mbr}}, \code{\link{ns}},
  \code{\link{ppt}}, \code{\link{prudent}},
  \code{\link{ps}}, \code{\link{rakel}}, \code{\link{rdbr}}

Other Pairwise methods: \code{\link{clr}}
}
