% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_annotation.R
\name{concatenateAnnotationResult}
\alias{concatenateAnnotationResult}
\title{Concatenate annotation result files into one file}
\usage{
concatenateAnnotationResult(
  varResultPath,
  annotationFinalResult,
  cores = NULL,
  verbose = FALSE
)
}
\arguments{
\item{varResultPath}{annotation result directory}

\item{annotationFinalResult}{final annotation file}

\item{cores}{(optional) number of cores you'd like to use, by default would use a single core.}

\item{verbose}{Whether print diagnostic messages. The default is FALSE.}
}
\value{
write concatenated annotation file to annotationFinalResult
}
\description{
\code{concatenateAnnotationResult} Concatenate annotation result files into one file
}
\examples{
\dontrun{
# After we run UTR annotation on all partition variant files and
# store the annotations in "partition_results" for example,
# we can concatenate the annotation results into one file and
# store it in concatenated_annotation.csv
concatenateAnnotationResult(varResultPath = "partition_results",
                            annotationFinalResult = "concatenated_annotation.csv")
}
}
