% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_annotation.R
\name{initUTRAnnotation}
\alias{initUTRAnnotation}
\title{Query transcripts regions and sequences from Ensembl database}
\usage{
initUTRAnnotation(
  variantFile,
  species,
  ensemblVersion,
  getTranscript = TRUE,
  format = "csv",
  dataDir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{variantFile}{a CSV file with Chr, Pos, Ref, Alt}

\item{species}{either human or mouse}

\item{ensemblVersion}{(optional) a number specifying which version of Ensembl annotation you'd like to use, by default use the latest version}

\item{getTranscript}{(optional) Whether to get ids of the transcripts that overlap with all the variants. If the number of variants is too large (for example > 100,000), set it to FALSE and do this in runUTRAnnotation on each partition in parallel.}

\item{format}{(optional) csv or vcf, the default is csv}

\item{dataDir}{(optional) path to the store the database information, if not specified will create a folder named as input variant file name with a "db_" prefix}

\item{verbose}{Whether print diagnostic messages. The default is FALSE.}
}
\value{
A variant table with Transcript column which contains the ids of the transcripts that overlap with the variants
}
\description{
\code{initUTRAnnotation} query transcripts regions, UTRs and coding sequences from Ensembl database, which will be used by \code{runUTRAnnotation} to do UTR annotation.
}
\examples{
\donttest{
test_variant_file <- system.file("extdata", "variants_sample.csv", package = "utr.annotation")
initUTRAnnotation(variantFile = test_variant_file,
                  species = "human",
                  ensemblVersion = 93,
                  dataDir = "test_db")
}
}
