% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_get_age_group.R
\name{get_age_group}
\alias{get_age_group}
\title{Construct age-group variable from age column}
\usage{
get_age_group(data_set, col_age, max_val, min_val = 0, step)
}
\arguments{
\item{data_set}{\code{data.frame} with at least a column containing the age
information}

\item{col_age}{Name of the column containing the age
information}

\item{max_val}{Maximum value of age interval to split}

\item{min_val}{Minimum value of age interval to split}

\item{step}{Step used to split the age interval}
}
\value{
Column of type \code{factor} with the same length as the number of rows
in \code{data_set}, with levels corresponding to age bins between \code{min_val} and
\code{max_val}. Ages above \code{max_val} are represented as \verb{>max_val}.
}
\description{
This method splits an age interval from \code{min_val} to \code{max_val}
into intervals of size \code{step}.
If the method finds ages greater or equal than \code{max_val}
it assigns the string \code{">max_val"}.
By default \code{min_val} is set to 0, however it can be assigned by
convenience. If the method finds ages lower or equal
than \code{min_val} it assigns the string \code{"<min_val-1"}.
The function warns when (max_val - min_val) is not an integer multiple of
step. In that case the last interval is truncated to the upper value
closest to max_val for which (closest_upper - min_val) is multiple of step.
}
\examples{
# load data provided with the package
data(cohortdata)

# assign age groups as a column of the `data.frame`
cohortdata$age_group <- get_age_group(
  data_set = cohortdata,
  col_age = "age",
  max_val = 80,
  step = 10
)

# view the `data.frame` with new column
head(cohortdata)
}
