% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R, R/expressionset.R
\docType{methods}
\name{meta}
\alias{meta}
\alias{meta<-}
\alias{meta,rule-method}
\alias{meta<-,rule,character-method}
\alias{meta,expressionset-method}
\alias{meta<-,expressionset,character-method}
\title{Get or set rule metadata}
\usage{
meta(x, ...)

meta(x, name) <- value

\S4method{meta}{rule}(x, ...)

\S4method{meta}{rule,character}(x, name) <- value

\S4method{meta}{expressionset}(x, simplify = TRUE, ...)

\S4method{meta}{expressionset,character}(x, name) <- value
}
\arguments{
\item{x}{an R object}

\item{...}{Arguments to be passed to other methods}

\item{name}{\code{[character]} metadata key}

\item{value}{Value to set}

\item{simplify}{Gather all metadata into a dataframe?}
}
\description{
Rule metadata are key-value pairs where the value is a simple (atomic)
string or number.
}
\examples{

v <- validator(x > 0, y > 0)

# metadata is recycled over rules
meta(v,"foo") <- "bar" 

# assign metadata to a selection of rules
meta(v[1],"fu") <- 2

# retrieve metadata as data.frame
meta(v)

# retrieve metadata as list
meta(v,simplify=TRUE)

}
\seealso{
Other expressionset-methods: \code{\link{as.data.frame,expressionset-method}},
  \code{\link{as.data.frame}}, \code{\link{created}},
  \code{\link{description}}, \code{\link{label}},
  \code{\link{names<-,rule,character-method}},
  \code{\link{origin}},
  \code{\link{plot,validator-method}},
  \code{\link{summary}}, \code{\link{variables}},
  \code{\link{voptions}}
}
