% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_reldist.r
\name{bed_reldist}
\alias{bed_reldist}
\title{Compute relative distances intervals.}
\usage{
bed_reldist(x, y, detail = FALSE)
}
\arguments{
\item{x}{tbl of intervals}

\item{y}{tbl of intervals}

\item{detail}{report relative distances for each \code{x} interval.}
}
\value{
\code{data_frame}
}
\description{
Compute relative distances intervals.
}
\examples{
x <- tibble::tribble(
  ~chrom,   ~start,    ~end,
  "chr1",    75,       125
)

y <- tibble::tribble(
  ~chrom,   ~start,    ~end,
  "chr1",    50,       100,
  "chr1",    100,       150
)

bed_reldist(x, y)

}
\seealso{
\url{http://bedtools.readthedocs.io/en/latest/content/tools/reldist.html}

Other interval-stats: \code{\link{bed_absdist}},
  \code{\link{bed_fisher}}, \code{\link{bed_jaccard}},
  \code{\link{bed_projection}}
}

