% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_window.r
\name{bed_window}
\alias{bed_window}
\title{Identify intervals within a specified distance.}
\usage{
bed_window(x, y, genome, ...)
}
\arguments{
\item{x}{tbl of intervals}

\item{y}{tbl of intervals}

\item{genome}{tbl of chrom sizes}

\item{...}{params for bed_slop and bed_intersect}
}
\description{
Identify intervals within a specified distance.
}
\details{
input tbls can be grouped using \code{\link[dplyr]{group_by}} prior to 
  analysis. Input tbls are grouped by \code{chrom} by default. Grouping by 
  \code{strand} will constrain analyses to the same strand. To compare 
  opposing strands between two tbls, strands on the \code{y} tbl can first be
  be inverted using \code{\link{flip_strands}}.
}
\examples{
x <- tibble::tribble(
 ~chrom, ~start, ~end,
 'chr1',      25,      50,
 'chr1',      100,     125
)
 
y <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1',      60,     75
)
 
genome = tibble::tribble(
  ~chrom, ~size,
  'chr1',      125
)
 
bed_glyph(bed_window(x, y, genome, both = 15)) 

x <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 10,    100,
  "chr2", 200,    400,
  "chr2", 300,    500,
  "chr2", 800,    900
)

y <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 150,    400,
  "chr2", 230,    430,
  "chr2", 350,    430
)

genome <- tibble::tribble(
  ~chrom, ~size,
  "chr1", 500,
  "chr2", 1000
)

bed_window(x, y, genome, both = 100)

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/window.html}

Other multi-set-ops: \code{\link{bed_closest}},
  \code{\link{bed_coverage}}, \code{\link{bed_intersect}},
  \code{\link{bed_map}}, \code{\link{bed_subtract}}
}

