% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Constants.R
\docType{data}
\name{names.resATs.carb.sulf}
\alias{names.resATs.carb.sulf}
\title{Carbon and Sulfur Residue-AtomType Names}
\format{An object of class \code{character} of length 109.}
\usage{
names.resATs.carb.sulf
}
\description{
Carbon and sulfur residue-atomtype names based on PDB atom
naming conventions.
}
\details{
These residue-atomtype names indicate carbon and sulfur atoms with a
neutral charge.
}
\examples{
 names.resATs.carb.sulf
 # [1] "ALA CA"  "ALA C"   "ALA CB"  "ARG CA"  "ARG C"   "ARG CB"  "ARG CG"
 # "ARG CD"  "ARG CZ"  "ASN CA"  "ASN C"   "ASN CB"  "ASN CG"  "ASP CA"  "ASP C"
 # [16] "ASP CB"  "ASP CG"  "CYS CA"  "CYS C"   "CYS CB"  "CYS SG"  "GLN CA"
 # "GLN C"   "GLN CB"  "GLN CG"  "GLN CD"  "GLU CA"  "GLU C"   "GLU CB"  "GLU CG"
 # [31] "GLU CD"  "GLY CA"  "GLY C"   "HIS CA"  "HIS C"   "HIS CB"  "HIS CG"
 # "HIS CD2" "HIS CE1" "ILE CA"  "ILE C"   "ILE CB"  "ILE CG1" "ILE CG2" "ILE CD1"
 # [46] "LEU CA"  "LEU C"   "LEU CB"  "LEU CG"  "LEU CD1" "LEU CD2" "LYS CA"
 # "LYS C"   "LYS CB"  "LYS CG"  "LYS CD"  "LYS CE"  "MET CA"  "MET C"   "MET CB"
 # [61] "MET CG"  "MET SD"  "MET CE"  "PHE CA"  "PHE C"   "PHE CB"  "PHE CG"
 # "PHE CD1" "PHE CD2" "PHE CE1" "PHE CE2" "PHE CZ"  "PRO CA"  "PRO C"   "PRO CB"
 # [76] "PRO CG"  "PRO CD"  "SER CA"  "SER C"   "SER CB"  "THR CA"  "THR C"
 # "THR CB"  "THR CG2" "TRP CA"  "TRP C"   "TRP CB"  "TRP CG"  "TRP CD1" "TRP CD2"
 # [91] "TRP CE2" "TRP CE3" "TRP CZ2" "TRP CZ3" "TRP CH2" "TYR CA"  "TYR C"
 # "TYR CB"  "TYR CG"  "TYR CD1" "TYR CD2" "TYR CE1" "TYR CE2" "TYR CZ"  "VAL CA"
 # [106] "VAL C"   "VAL CB"  "VAL CG1" "VAL CG2"

}
\seealso{
Other constants: \code{\link{names.backbone.atoms}},
  \code{\link{names.polar.atoms}},
  \code{\link{names.res.AtomTypes}},
  \code{\link{names.resATs.nitro.neut}},
  \code{\link{names.resATs.nitro.pos}},
  \code{\link{names.resATs.oxy.neg}},
  \code{\link{names.resATs.oxy.neut}},
  \code{\link{names.residues}},
  \code{\link{names.sidechain.atoms}},
  \code{\link{names.waters}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\keyword{datasets}
