% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsxCommands.R
\name{oxPDBcleanedSummarySheet}
\alias{oxPDBcleanedSummarySheet}
\title{Cleaned PDB Structures Data Sheet}
\usage{
oxPDBcleanedSummarySheet(wb.name, sheet.name = "PDBcleanedSummary", df)
}
\arguments{
\item{wb.name}{Name of the workbook for the results; \emph{e.g.}, results.wb}

\item{sheet.name}{Name of the worksheet being formatted; default:
\code{"PDBcleanedSummary"}}

\item{df}{data.frame containing the summary of
\code{\link[=CleanProteinStructures]{CleanProteinStructures()}}; \emph{e.g.}, \code{df.results}}
}
\value{
The workbook containing the indicated and newly formatted worksheet.
}
\description{
Constructs the \link{openxlsx} worksheet for the
\code{\link[=CleanProteinStructures]{CleanProteinStructures()}} results.
}
\details{
\strong{This function is to \emph{ONLY} be used with the results of
\code{\link[=CleanProteinStructures]{CleanProteinStructures()}}}. Specific aspects of how the
returned \code{data.frame} will be formatted are \strong{hard-coded} into this
function.

Notable formatting:
\itemize{
\item Top row frozen
\item Column widths are set based on column content
\item Structures with hydrogen atoms removed are highlighted with amber cell color
\item Structures with OoR values, modeled atoms, and removed waters are highlighted
with amber cell color
}

This \link{openxlsx} function is \emph{\strong{NOT}} exported.
}
\seealso{
Other "openxlsx functions": \code{\link{openxlsxCellStyles}},
  \code{\link{oxAlignOverlapSheet}},
  \code{\link{oxClusterStatsSheet}},
  \code{\link{oxClusterSummarySheet}},
  \code{\link{oxInitWaterDataSheet}},
  \code{\link{oxPlainDataSheet}},
  \code{\link{oxRCSBinfoSheet}},
  \code{\link{oxWaterOccurrenceSheet}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
