% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{ConservationSet}
\alias{ConservationSet}
\title{Conservation Set}
\usage{
ConservationSet(pct.conserved)
}
\arguments{
\item{pct.conserved}{A \code{vector} from containing the \code{\link[=ConservedWaters]{ConservedWaters()}}
function containing the percent conservation (\code{pct.conserved})}
}
\value{
vector indicating the conservation set
}
\description{
Assign the percent conservation to a "set#" for plotting.
}
\details{
Several of the plots color-code conserved water clusters based on
percent conservation (see \code{\link[=ClusterSummaryPlots]{ClusterSummaryPlots()}} for color-coding) and is
controlled by a \code{conserve.set} column. This function assigns less than 50\%
conservation to \code{set0}, 50 to 69\% \code{set1}, 70 to 79\% \code{set2}, 80 to 89\%
\code{set3}, 90 to 99\% \code{set4}, and eqaul to 100\% \code{set5},

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  pct.conserved <- c(100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50,
                      45, 40, 35, 30, 25, 20, 15, 10, 10)
  ConservationSet(pct.conserved)
  # [1] "set5" "set4" "set4" "set3" "set3" "set2" "set2" "set1" "set1" "set1"
  # "set1" "set0" "set0" "set0" "set0" "set0" "set0" "set0" "set0" "set0"
  }

}
\seealso{
Other utilities: \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
