% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Constants.R
\name{colorPalettes}
\alias{colorPalettes}
\title{Color Values for Plots}
\description{
Color values for plots with percent waters conserved plots.
}
\details{
The five (5) and six (6) color palettes are to used to color-code
the plots illustrating percent water conserved (water conservation). The
five color palette is for conservation values between 50\% to 100\% and the
six color palette includes a color for less than 50\% conservation.

The colors are based on "percent conservation" with light grey dots
indicating clusters with less than 50\% conservation, dark red dots
representing clusters with 50\% to 69\% conservations, red dots are
clusters with 70\% to 79\% conservation, light blue dots have 80\% to 89\%
conservation, blue dots are clusters with 90\% to 99\% conservation, and
dark blue dots are 100\% conserved water clusters (all structures
contribute to the water cluster).

The defined colors are:
\itemize{
\item \strong{cons.color5}: red, medium red, light blue, medium blue, and dark blue
\item \strong{cons.color6}: light grey, red, medium red, light blue, medium blue,
and dark blue
}

The defined legend titles are:
\itemize{
\item \strong{cons.color5.legend}: Water Conservation
\item \strong{cons.color6.legend}: Water Conservation
}

The defined break titles are:
\itemize{
\item \strong{cons.color5.breaks}: set1, set2, set3, set4, and set5
\item \strong{cons.color6.breaks}: set0, set1, set2, set3, set4, and set5
}

The defined labels are:
\itemize{
\item \strong{cons.color5.labels}: 50-69\%, 70-79\%, 80-89\%, 90-99\%, 100\%
\item \strong{cons.color6.labels}: < 50\%, 50-69\%, 70-79\%, 80-89\%, 90-99\%, 100\%
}
}
\references{
Cynthia A Brewer. 200x.
\url{http://www.ColorBrewer.org}, accessed
March 27, 2017.
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"vanddraabe plots"}
