% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getAtomTypeCounts}
\alias{getAtomTypeCounts}
\title{Get AtomType Counts}
\usage{
getAtomTypeCounts(atom.types)
}
\arguments{
\item{atom.types}{A vector of strings containing a combination of the 167
AtomTypes.}
}
\value{
a vector of numbers indicating the counts of each AtomType. The
vector is ordered based on the \code{names.AtomTypes} with AtomTypes not
included assigned a value of zero (0).
}
\description{
Counts the number of AtomTypes within the provided string.
}
\details{
This is a wrapper using the \code{\link[base:table]{base::table()}} function. The
vector of AtomTypes (\code{strings}) are passed to the function,
non-standard AtomTypes are removed, the AtomTypes are counted, and the
counts are ordered based on the \code{names.AtomTypes} constant.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  set.seed(13)
  num.AtomTypes <- sample(1:10, 30, replace = TRUE)
  atom.types <- rep(sample(names.res.AtomTypes, 30), num.AtomTypes)
  getAtomTypeCounts(atom.types)
  # [1]  0  0  0  0  0  0  0  0  0  0  0  0  0  7  1  0  0  0  0
  #      0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0
  #      0  0  0  4  0  0  0  0  4  3  6  0  0  0  0  0  0  0  0
  #      0  0 10  0  8  0  0  0  0  0  0  0  0  0  0  0  0  0  6
  #      4  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
  #      0  5  0  0  0  0  0  0  0  7  0  0  0  0  0  0  0  7  0
  #      3  0  0  5  3  0  5  0  0  5  8  0  8  0  8  0  0  0  0
  #      0  0  2  0  0  1  0  0  0  3  0  0  6  0  0  0  0  0  3
  #      0  0  0  0 10  0  0  0  0  0  0  1  0  0  0
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
