% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRCSBdata.R
\name{getRCSBdata}
\alias{getRCSBdata}
\title{Clean RCSB Dataset}
\usage{
getRCSBdata(prefix = "./alignTesting", resolution = 3, rFree = 0.26,
  rObserved = 0.2, filename = "ProteinSystem")
}
\arguments{
\item{prefix}{Directory of aligned structures; string.}

\item{resolution}{Structures with a \code{resolution} value greater than this
value are removed from analysis; default: \code{3.0}}

\item{rFree}{Structures with a \code{rFree} values greater than this value are
removed from analysis; default: \code{0.26}}

\item{rObserved}{Structures with a \code{rObserved} values greater than this value
are removed from analysis; default: 0.20}

\item{filename}{The filename prefix for the returned results. Default is
"ProteinSystem"}
}
\value{
This function returns:
\itemize{
\item \strong{PDB.info}: RCSB provided information for all protein structures
\item \strong{PDB.info.passed}: RCSB provided information for all protein
structures \emph{\strong{passing}} the user defined parameters
\item \strong{PDB.info.rejected}: RCSB provided information for all protein
structures \emph{\strong{failing}} the user defined parameters
\item \strong{call}: parameters provided by the user
\item \strong{Excel workbook}: containing the PDB.info, PDB.info.passed, and
PDB.info.rejected data as individual tabs
}
}
\description{
Clean the protein dataset based on quality values.
}
\details{
The provided protein models determined by X-ray crystallography
and downloaded from the RCSB include structure quality measures.
The resolution, rObservation, and rFree are the three commonly used
and referenced evaluation measures.

The B-value normalization exclusion value is user defined within the main
\code{\link[=ConservedWaters]{ConservedWaters()}} function but has a default value of 1.0.
}
\examples{
  \dontrun{
  proteins.info <- getRCSBdata(prefix="./thrombin_fitlsq_1.0ang/",
                               resolution=3.0, rFree=NULL, rObserved= 0.20,
                               filename="ProteinSystem")
  }

}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{Clean RCSB dataset}
