% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chibarsquare.R
\name{weightsChiBarSquare}
\alias{weightsChiBarSquare}
\title{Chi-bar-square weights computation}
\usage{
weightsChiBarSquare(df, V, dimsCone, orthan, control)
}
\arguments{
\item{df}{a vector with the degrees of freedom of the chi-square components of the chi-bar-square distribution}

\item{V}{a positive semi-definite matrix}

\item{dimsCone}{a list with the dimensions of the cone C, expressed on the parameter space scale}

\item{orthan}{a boolean specifying whether the cone is an orthan}

\item{control}{(optional) a list of control options for the computation of the chi-bar-weights, containing 
two elements: \code{parallel} a boolean indicating whether computation should be done in parallel (FALSE 
by default), \code{nb_cores} the number of cores for parallel computing (if \code{parallel=TRUE} but no value is given
for \code{nb_cores}, it is set to number of detected cores minus 1), and \code{M} the Monte Carlo sample
size for the computation of the weights.}
}
\value{
A list containing the estimated weights, the standard deviations of the estimated weights and the
random sample of \code{M} realizations from the chi-bar-square distribution
}
\description{
The function computes an approximation of the weights of the chi-bar-square distribution
\eqn{\bar{\chi}^2(V,C)}, with V a positive semi-definite matrix and C a convex cone.
}
