\name{fevd}

\alias{fevd}

\alias{fevd.varest}

\alias{fevd.svarest}

\alias{fevd.vec2var}

\alias{print.varfevd}

\title{Forecast Error Variance Decomposition}

\encoding{latin1}

\description{
  Computes the forecast error variance decomposition of a VAR(p) for
  \code{n.ahead} steps. 
}

\usage{
\method{fevd}{varest}(x, n.ahead=10, ...)
\method{fevd}{svarest}(x, n.ahead=10, ...)
\method{fevd}{vec2var}(x, n.ahead=10, ...)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}, or an object of class \sQuote{\code{svarest}};
    generated by \command{SVAR()}, or an object of class
    \sQuote{\code{vec2var}}; generated by \command{vec2var()}.}  
  \item{n.ahead}{Integer specifying the steps.}
  \item{...}{Currently not used.}
}

\details{
  The forecast error variance decomposition is based upon the
  orthogonalised impulse response coefficient matrices \eqn{\Psi_h} and
  allow the user to analyse the contribution of variable \eqn{j} to the
  h-step forecast error variance of variable \eqn{k}. If the
  orthogonalised impulse reponses are divided by the variance of the
  forecast error \eqn{\sigma_k^2(h)}, the resultant is a percentage
  figure. Formally:

  \deqn{
    \sigma_k^2(h) = \sum_{n=0}^{h-1}(\psi_{k1, n}^2 + \ldots + \psi_{kK, n}^2)
  }
  which can be written as:

  \deqn{
    \sigma_k^2(h) = \sum_{j=1}^K(\psi_{kj, 0}^2 + \ldots + \psi_{kj,
      h-1}^2) \quad.
  }
  Dividing the term \eqn{(\psi_{kj, 0}^2 + \ldots + \psi_{kj, h-1}^2)}
  by \eqn{\sigma_k^2(h)} yields the forecast error variance
  decompositions in percentage terms.
}

\value{
  A list with class attribute \sQuote{\code{varfevd}} of length \code{K}
  holding the forecast error variances as matrices.
}  
\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}, \code{\link{SVAR}}, \code{\link{vec2var}}, \code{\link{Phi}}, \code{\link{Psi}}, \code{\link{plot.varfevd}} 
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
fevd(var.2c, n.ahead = 5)
}


\keyword{regression}
\concept{VAR}
\concept{Vector autoregressive model}
\concept{fevd}
\concept{forecast error variance decomposition}
\concept{VECM}