% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_api_client.R
\name{vault_api_client}
\alias{vault_api_client}
\title{Vault Low-Level Client}
\description{
Vault Low-Level Client

Vault Low-Level Client
}
\details{
Low-level API client.  This can be used to directly communicate
with the vault server.  This object will primarily be useful for
debugging, testing or developing new vault methods, but is
nonetheless described here.
}
\examples{

server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  # Ordinarily, we would use the "vault_client" object for
  # high-level access to the vault server
  client <- server$client()
  client$status()

  # The api() method returns the "api client" object:
  api <- client$api()
  api

  # This allows running arbitrary HTTP requests against the server:
  api$GET("/sys/seal-status")

  # this is how vaultr is internally implemented so anything can
  # be done here, for example following vault's API documentation
  # https://www.vaultproject.io/api/secret/kv/kv-v1.html#sample-request-2
  api$POST("/secret/mysecret", body = list(key = "value"))
  api$GET("/secret/mysecret")
  api$DELETE("/secret/mysecret")

  # cleanup
  server$kill()
}
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_api_client}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{addr}}{The vault address (with protocol, hostname and port)}

\item{\code{base_url}}{The base url (with protocol, hostname, port and
api version path)}

\item{\code{tls_config}}{Information used in TLS config, if used}

\item{\code{token}}{The vault token, if authenticated}

\item{\code{version}}{The vault server version, once queried}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-vault_api_client-new}{\code{vault_api_client$new()}}
\item \href{#method-vault_api_client-request}{\code{vault_api_client$request()}}
\item \href{#method-vault_api_client-is_authenticated}{\code{vault_api_client$is_authenticated()}}
\item \href{#method-vault_api_client-set_token}{\code{vault_api_client$set_token()}}
\item \href{#method-vault_api_client-verify_token}{\code{vault_api_client$verify_token()}}
\item \href{#method-vault_api_client-server_version}{\code{vault_api_client$server_version()}}
\item \href{#method-vault_api_client-GET}{\code{vault_api_client$GET()}}
\item \href{#method-vault_api_client-LIST}{\code{vault_api_client$LIST()}}
\item \href{#method-vault_api_client-POST}{\code{vault_api_client$POST()}}
\item \href{#method-vault_api_client-PUT}{\code{vault_api_client$PUT()}}
\item \href{#method-vault_api_client-DELETE}{\code{vault_api_client$DELETE()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-format'><code>vaultr::vault_client_object$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-help'><code>vaultr::vault_client_object$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-new"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-new}{}}}
\subsection{Method \code{new()}}{
Create a new api client
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$new(addr = NULL, tls_config = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{addr}}{Address of the vault server}

\item{\code{tls_config}}{Optional TLS config}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-request"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-request}{}}}
\subsection{Method \code{request()}}{
Make a request to the api. Typically you should use
one of the higher-level wrappers, such as \verb{$GET} or \verb{$POST}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$request(verb, path, ..., token = self$token)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verb}}{The HTTP verb to use, as a \code{httr} function (e.g.,
pass \code{httr::GET} for a \code{GET} request).}

\item{\code{path}}{The request path}

\item{\code{...}}{Additional arguments passed to the \code{httr} function}

\item{\code{token}}{Optional token, overriding the client token}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-is_authenticated"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-is_authenticated}{}}}
\subsection{Method \code{is_authenticated()}}{
Test if the vault client currently holds a vault token.
This method does not verify the token - only test that is present.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$is_authenticated()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-set_token"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-set_token}{}}}
\subsection{Method \code{set_token()}}{
Set a token within the client
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$set_token(token, verify = FALSE, quiet = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{String, with the new vault client token}

\item{\code{verify}}{Logical, indicating if we should test that the token
is valid. If \code{TRUE}, then we use \verb{$verify_token()} to test the
token before setting it and if it is not valid an error will be
thrown and the token not set.}

\item{\code{quiet}}{Logical, if \code{TRUE}, then informational messages will be
suppressed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-verify_token"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-verify_token}{}}}
\subsection{Method \code{verify_token()}}{
Test that a token is valid with the vault.
This will call vault's \verb{/sys/capabilities-self} endpoint with the
token provided and check the \verb{/sys} path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$verify_token(token, quiet = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{String, with the vault client token to test}

\item{\code{quiet}}{Logical, if \code{TRUE}, then informational messages will be
suppressed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-server_version"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-server_version}{}}}
\subsection{Method \code{server_version()}}{
Retrieve the vault server version.  This is by default
cached within the client for a session.  Will return an R
\link{numeric_version} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$server_version(refresh = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{refresh}}{Logical, indicating if the server version information
should be refreshed even if known.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-GET"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-GET}{}}}
\subsection{Method \code{GET()}}{
Send a \code{GET} request to the vault server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$GET(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The server path to use.  This is the "interesting"
part of the path only, with the server base url and api version
information added.}

\item{\code{...}}{Additional \code{httr}-compatible options.  These will be named
parameters or \code{httr} "request" objects.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-LIST"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-LIST}{}}}
\subsection{Method \code{LIST()}}{
Send a \code{LIST} request to the vault server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$LIST(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The server path to use.  This is the "interesting"
part of the path only, with the server base url and api version
information added.}

\item{\code{...}}{Additional \code{httr}-compatible options.  These will be named
parameters or \code{httr} "request" objects.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-POST"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-POST}{}}}
\subsection{Method \code{POST()}}{
Send a \code{POST} request to the vault server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$POST(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The server path to use.  This is the "interesting"
part of the path only, with the server base url and api version
information added.}

\item{\code{...}}{Additional \code{httr}-compatible options.  These will be named
parameters or \code{httr} "request" objects.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-PUT"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-PUT}{}}}
\subsection{Method \code{PUT()}}{
Send a \code{PUT} request to the vault server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$PUT(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The server path to use.  This is the "interesting"
part of the path only, with the server base url and api version
information added.}

\item{\code{...}}{Additional \code{httr}-compatible options.  These will be named
parameters or \code{httr} "request" objects.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_api_client-DELETE"></a>}}
\if{latex}{\out{\hypertarget{method-vault_api_client-DELETE}{}}}
\subsection{Method \code{DELETE()}}{
Send a \code{DELETE} request to the vault server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_api_client$DELETE(path, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The server path to use.  This is the "interesting"
part of the path only, with the server base url and api version
information added.}

\item{\code{...}}{Additional \code{httr}-compatible options.  These will be named
parameters or \code{httr} "request" objects.}
}
\if{html}{\out{</div>}}
}
}
}
