% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetic_diff.R
\name{genetic_diff}
\alias{genetic_diff}
\title{Genetic differentiation}
\usage{
genetic_diff(vcf, pops, method = "nei")
}
\arguments{
\item{vcf}{a vcfR object}

\item{pops}{factor indicating populations}

\item{method}{the method to measure differentiation}
}
\description{
Calculate measures of genetic differentiation.
}
\details{
Measures of genetic differentiation, or fixation indicies, are commonly reported population genetic parameters.
This function reports genetic differentiation for all variants presented to it.

The method \strong{nei} returns Nei's Gst as well as Hedrick's G'st, a correction for high alleleism (Hedrick 2005).
Here it is calculated as in equation 2 from Hedrick (2005) with the exception that the heterozygosities are weighted by the number of alleles observed in each subpopulation.
This is similar to \code{hierfstat::pairwise.fst()} but by using the number of alleles instead of the number of individuals it avoids making an assumption about how many alleles are contributed by each individual.
G'st is calculated as in equation 4b from Hedrick (2005).
This method is based on heterozygosity where all of the alleles in a population are used to calculate allele frequecies.
This may make this a good choice when there is a mixture of ploidies in the sample.

The method \strong{jost} return's Jost's D as a measure of differentiation.
This is calculated as in equation 13 from Jost (2008).
Examples are available at Jost's website: \url{http://www.loujost.com}.

A nice review of Fst and some of its analogues can be found in Holsinger and Weir (2009).
}
\examples{
data(vcfR_example)
myPops <- as.factor(rep(c('a','b'), each = 9))
myDiff <- genetic_diff(vcf, myPops, method = "nei")
colMeans(myDiff[,c(3:8,11)], na.rm = TRUE)
hist(myDiff$Gprimest, xlab = expression(italic("G'"["ST"])), 
     col='skyblue', breaks = seq(0, 1, by = 0.01))


}
\references{
Hedrick, Philip W. "A standardized genetic differentiation measure." Evolution 59.8 (2005): 1633-1638.

Holsinger, Kent E., and Bruce S. Weir. "Genetics in geographically structured populations: defining, estimating and interpreting FST." Nature Reviews Genetics 10.9 (2009): 639-650.

Jost, Lou. "GST and its relatives do not measure differentiation." Molecular ecology 17.18 (2008): 4015-4026.

Whitlock, Michael C. "G'ST and D do not replace FST." Molecular Ecology 20.6 (2011): 1083-1091.
}
\seealso{
poppr.amova in \href{https://cran.r-project.org/package=poppr}{poppr}, amova in \href{https://cran.r-project.org/package=ade4}{ade4}, amova in \href{https://cran.r-project.org/package=pegas}{pegas}, \href{https://cran.r-project.org/package=hierfstat}{hierfstat}, \href{https://cran.r-project.org/package=DEMEtics}{DEMEtics}, and, \href{https://cran.r-project.org/package=mmod}{mmod}.
}
