% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_gt.R
\name{query.gt}
\alias{query.gt}
\alias{is.polymorphic}
\alias{is.biallelic}
\alias{is_biallelic}
\title{Query the gt slot}
\usage{
is.polymorphic(x, na.omit = FALSE)

is.biallelic(x)
}
\arguments{
\item{x}{an object of class vcfR}

\item{na.omit}{logical to omit missing data}
}
\description{
Query the 'gt' slot of objects of class vcfR
}
\details{
The function \strong{is_polymorphic} returns a vector of logicals indicating whether a variant is polymorphic.
Only variable sites are reported in vcf files.
However, once someone manipulates a vcfR object, a site may become invariant.
For example, if a sample is removed it may result in a site becoming invariant.
This function queries the sites in a vcfR object and returns a vector of logicals (TRUE/FALSE) to indicate if they are actually variable.

The function \strong{is_bialleleic} returns a vector of logicals indicating whether a variant is biallelic.
Some analyses or downstream analyses only work with biallelic loci.
This function can help manage this.

Note that \strong{is_bialleleic} queries the ALT column in the fix slot to count alleles.
If you remove samples from the gt slot you may invalidate the information in the fix slot.
For example, if you remove the samples with the alternate allele you will make the position invariant and this function will provide inaccurate information.
So use caution if you've made many modifications to your data.
}
\seealso{
\code{\link{extract.gt}}
}
