% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.mean.ps}
\alias{se.mean.ps}
\title{Computes the standard error for a paired-samples mean difference}
\usage{
se.mean.ps(m1, m2, sd1, sd2, cor, n)
}
\arguments{
\item{m1}{sample mean for measurement 1}

\item{m2}{sample mean for measurement 2}

\item{sd1}{sample standard deviation for measurement 1}

\item{sd2}{sample standard deviation for measurement 2}

\item{cor}{sample correlation for measurements 1 and 2}

\item{n}{sample size}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimate of mean difference
\item SE - standard error
}
}
\description{
This function can be used to compute the standard error of a
paired-samples mean difference using the two sample means, sample
effect size estimate and standard error output from this function
can be used as input in the \link[vcmeta]{meta.ave.gen},
\link[vcmeta]{meta.lc.gen}, and \link[vcmeta]{meta.lm.gen} functions in
applications where compatible mean differences from a combination of 2-group
and paired-samples experiments are used in the meta-analysis.
}
\examples{
se.mean.ps(23.9, 25.1, 1.76, 2.01, .78, 25)

# Should return:
#                  Estimate        SE
# Mean difference:     -1.2 0.2544833

}
\references{
\insertRef{Snedecor1980}{vcmeta}
}
