% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.spear}
\alias{replicate.spear}
\title{Compares and combines Spearman correlations in original and follow-up studies}
\usage{
replicate.spear(alpha, cor1, n1, cor2, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor1}{estimated Spearman correlation in original study}

\item{n1}{sample size in original study}

\item{cor2}{estimated Spearman correlation in follow-up study}

\item{n2}{sample size in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference between studies
\item Row 4 estimates the average effect size for the two studies
}

The columns are:
\itemize{
\item Estimate - Spearman correlation estimate (single study, difference, average)
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function can be used to compare and combine Spearman correlations from
the original study and the follow-up study. The confidence level for the
difference is 1 – 2alpha.
}
\examples{
replicate.spear(.05, .598, 80, .324, 200)

# Should return:
#                      Estimate         SE        z            p         LL        UL
# Original:                0.598 0.07948367 5.315140 1.065752e-07 0.41985966 0.7317733
# Follow-up:               0.324 0.06541994 4.570582 4.863705e-06 0.19049455 0.4457384
# Original - Follow-up:    0.274 0.10294378 3.437975 5.860809e-04 0.09481418 0.4342171
# Average:                 0.461 0.05147189 9.967944 0.000000e+00 0.36695230 0.5457190


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
