% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order.R
\name{vec_locate_sorted_groups}
\alias{vec_locate_sorted_groups}
\title{Locate sorted groups}
\usage{
vec_locate_sorted_groups(
  x,
  ...,
  direction = "asc",
  na_value = "largest",
  nan_distinct = FALSE,
  chr_proxy_collate = NULL
)
}
\arguments{
\item{x}{A vector}

\item{...}{These dots are for future extensions and must be empty.}

\item{direction}{Direction to sort in.
\itemize{
\item A single \code{"asc"} or \code{"desc"} for ascending or descending order
respectively.
\item For data frames, a length \code{1} or \code{ncol(x)} character vector containing
only \code{"asc"} or \code{"desc"}, specifying the direction for each column.
}}

\item{na_value}{Ordering of missing values.
\itemize{
\item A single \code{"largest"} or \code{"smallest"} for ordering missing values as the
largest or smallest values respectively.
\item For data frames, a length \code{1} or \code{ncol(x)} character vector containing
only \code{"largest"} or \code{"smallest"}, specifying how missing values should
be ordered within each column.
}}

\item{nan_distinct}{A single logical specifying whether or not \code{NaN} should
be considered distinct from \code{NA} for double and complex vectors. If \code{TRUE},
\code{NaN} will always be ordered between \code{NA} and non-missing numbers.}

\item{chr_proxy_collate}{A function generating an alternate representation
of character vectors to use for collation, often used for locale-aware
ordering.
\itemize{
\item If \code{NULL}, no transformation is done.
\item Otherwise, this must be a function of one argument. If the input contains
a character vector, it will be passed to this function after it has been
translated to UTF-8. This function should return a character vector with
the same length as the input. The result should sort as expected in the
C-locale, regardless of encoding.
}

For data frames, \code{chr_proxy_collate} will be applied to all character
columns.

Common transformation functions include: \code{tolower()} for case-insensitive
ordering and \code{stringi::stri_sort_key()} for locale-aware ordering.}
}
\value{
A two column data frame with size equal to \code{vec_size(vec_unique(x))}.
\itemize{
\item A \code{key} column of type \code{vec_ptype(x)}.
\item A \code{loc} column of type list, with elements of type integer.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{vec_locate_sorted_groups()} returns a data frame containing a \code{key} column
with sorted unique groups, and a \code{loc} column with the locations of each
group in \code{x}. It is similar to \code{\link[=vec_group_loc]{vec_group_loc()}}, except the groups are
returned sorted rather than by first appearance.
}
\details{
\code{vec_locate_sorted_groups(x)} is equivalent to, but faster than:\preformatted{info <- vec_group_loc(x)
vec_slice(info, vec_order(info$key))
}
}
\section{Dependencies of \code{vec_locate_sorted_groups()}}{

\itemize{
\item \code{\link[=vec_proxy_order]{vec_proxy_order()}}
}
}

\examples{
df <- data.frame(
  g = sample(2, 10, replace = TRUE),
  x = c(NA, sample(5, 9, replace = TRUE))
)

# `vec_locate_sorted_groups()` is similar to `vec_group_loc()`, except keys
# are returned ordered rather than by first appearance.
vec_locate_sorted_groups(df)

vec_group_loc(df)
}
\keyword{internal}
