% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_info.R
\name{pi_info}
\alias{pi_info}
\title{Create a prediction interval object}
\usage{
pi_info(level, lpi, upi)
}
\arguments{
\item{level}{a number in the interval (0, 100) indicating the level of the
prediction interval.}

\item{lpi}{a time series of class \code{ts} or a vector. Lower limit of a
prediction interval.}

\item{upi}{a time series of class \code{ts} or a vector. Upper limit of a
prediction interval.}
}
\value{
An object of class \code{pi_info}. It is a list containing all the
information supplied to the function.
}
\description{
The object created represents a prediction interval for the forecast of the
future values of a time series.
}
\examples{
if (require("forecast")) {
  time_series <- ts(rnorm(40))
  f <- meanf(time_series, level = 95)
  info <- pi_info(95, f$lower, f$upper)
}
}
\seealso{
\code{\link[=prediction_info]{prediction_info()}} which uses this function to specify prediction
intervals.
}
