% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_cetesb.R
\name{ef_cetesb}
\alias{ef_cetesb}
\title{Emissions factors for Environment Company of Sao Paulo, Brazil (CETESB) 2017}
\usage{
ef_cetesb(p, veh, year = 2017, agemax = 40, full = FALSE,
  project = "constant")
}
\arguments{
\item{p}{Character; Pollutants: "COd", "HCd", "NMHCd", "CH4", "NOxd", "CO2",
"PM", "N2O", "KML", "FC", "NO2d", "NOd", "gD/KWH", "gCO2/KWH", "RCHOd",
"CO", "HC", "NMHC", "NOx", "NO2" ,"NO", "RCHO" (g/km). The letter 'd' means deteriorated
factor. Also, evaporative emissions at average temperature ranges:
"D_20_35", "S_20_35", "R_20_35", "D_10_25", "S_10_25", "R_10_25", "D_0_15",
"S_0_15" and "R_0_15" where D means diurnal (g/day), S hot/warm soak (g/trip)
and R hot/warm running losses (g/trip).}

\item{veh}{Character; Vehicle categories: "PC_G", "PC_FG", "PC_FE", "PC_E",
"LCV_G", "LCV_FG", "LCV_FE", "LCV_E", "LCV_D", "SLT", "LT", "MT", "SHT",
"HT", "UB", "SUB", "COACH", "ARTIC", "M_G_150", "M_G_150_500", "M_G_500",
"M_FG_150", "M_FG_150_500", "M_FG_500", "M_FE_150", "M_FE_150_500",
"M_FE_500", "CICLOMOTOR", "GNV"}

\item{year}{Numeric; Filter the emission factor to start from a specific base year.
If project is 'constant' values above 2017 and below 1980 will be repeated}

\item{agemax}{Integer; age of oldest vehicles for that category}

\item{full}{Logical; To return a data.frame instead or a vector adding
Age, Year, Brazilian emissions standards and its euro equivalents.}

\item{project}{haracter showing the method for projecting emission factors in
future. Currently the only value is "constant"}
}
\value{
A vector of Emission Factor or a data.frame
}
\description{
\code{\link{ef_cetesb}} returns a vector or data.frame of Brazilian emission factors.
}
\note{
This emission factors are not exactly the same as the report of CETESB.

1) In this emission factors, there is also NO and NO2 based on split by
published in the EMEP/EEA air pollutant emission inventory guidebook.

2) Also, the emission factors were extended till 50 years of use, repeating
the oldest value.

3) CNG emission factors were expanded to other pollutants by comparison
of US.EPA-AP42 emission factor: Section 1.4 Natural Gas Combustion.
}
\examples{
{
a <- ef_cetesb("CO", "PC_G")
a <- ef_cetesb("R_10_25", "PC_G")
a <- ef_cetesb("CO", c("PC_G", "PC_FE"))
ef_cetesb(p = "CO", veh = "PC_G", year = 2018, agemax = 40)
ef_cetesb(p = "CO", veh = "PC_G", year = 1970, agemax = 40)
ef_cetesb(p = "CO", veh = "PC_G", year = 2030, agemax = 40)
}
}
\references{
Emissoes Veiculares no Estado de Sao Paulo 2016. Technical Report.
url: https://cetesb.sp.gov.br/veicular/relatorios-e-publicacoes/.
}
\keyword{emission}
\keyword{factors}
