% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_fact.R
\name{temp_fact}
\alias{temp_fact}
\title{Expansion of hourly traffic data}
\usage{
temp_fact(q, pro, net)
}
\arguments{
\item{q}{Numeric; traffic data per each link}

\item{pro}{Numeric; expansion factors data-frames}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}
}
\value{
data-frames of expanded traffic or sf.
}
\description{
\code{temp_fact} is a matrix multiplication between traffic and
hourly expansion data-frames to obtain a data-frame of traffic
at each link to every hour
}
\examples{
\dontrun{
# Do not run
data(net)
data(pc_profile)
pc_week <- temp_fact(net$ldv+net$hdv, pc_profile)
plot(pc_week)
pc_weeksf <- temp_fact(net$ldv+net$hdv, pc_profile, net = net)
plot(pc_weeksf)
}
}
