% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vkm.R
\name{vkm}
\alias{vkm}
\title{Estimation of VKM}
\usage{
vkm(
  veh,
  lkm,
  profile,
  hour = nrow(profile),
  day = ncol(profile),
  array = TRUE,
  as_df = TRUE
)
}
\arguments{
\item{veh}{Numeric vector with number of vehicles per street}

\item{lkm}{Length of each link (km)}

\item{profile}{Numerical or dataframe with nrows equal to 24 and ncol 7 day of the week}

\item{hour}{Number of considered hours in estimation}

\item{day}{Number of considered days in estimation}

\item{array}{When FALSE produces a dataframe of the estimation. When TRUE expects a
profile as a dataframe producing an array with dimensions (streets x hours x days)}

\item{as_df}{Logical; when TRUE transform returning array in data.frame (streets x hour*days)}
}
\value{
emission estimation  of vkm
}
\description{
\code{vkm} consists in the product of the number of vehicles and
the distance driven by these vehicles in km. This function reads hourly
vehiles and then extrapolates the vehicles
}
\examples{
\dontrun{
# Do not run
pc <- lkm <- abs(rnorm(10,1,1))*100
pro <- matrix(abs(rnorm(24*7,0.5,1)), ncol=7, nrow=24)
vkms  <- vkm(veh = pc, lkm = lkm, profile = pro)
class(vkms)
dim(vkms)
vkms2  <- vkm(veh = pc, lkm = lkm, profile = pro, as_df = FALSE)
class(vkms2)
dim(vkms2)
}
}
