% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_hdv_speed.R
\name{ef_hdv_speed}
\alias{ef_hdv_speed}
\title{Emissions factors for Heavy Duty Vehicles based on average speed}
\usage{
ef_hdv_speed(
  v,
  t,
  g,
  eu,
  x,
  gr = 0,
  l = 0.5,
  p,
  k = 1,
  show.equation = FALSE,
  speed,
  fcorr = rep(1, 8)
)
}
\arguments{
\item{v}{Category vehicle: "Coach", "Trucks" or "Ubus"}

\item{t}{Sub-category of of vehicle: "3Axes", "Artic", "Midi", "RT, "Std" and "TT"}

\item{g}{Gross weight of each category: "<=18", ">18", "<=15", ">15 & <=18", "<=7.5",
">7.5 & <=12", ">12 & <=14", ">14 & <=20", ">20 & <=26", ">26 & <=28", ">28 & <=32",
">32", ">20 & <=28", ">28 & <=34", ">34 & <=40", ">40 & <=50" or ">50 & <=60"}

\item{eu}{Euro emission standard: "PRE", "I", "II", "III", "IV", "V". Also "II+CRDPF",
"III+CRDPF", "IV+CRDPF", "II+SCR", "III+SCR" and "V+SCR" for pollutants
Number of particles and Active Surface.}

\item{x}{Numeric; if pollutant is "SO2", it is sulphur in fuel in ppm, if is
"Pb", Lead in fuel in ppm.}

\item{gr}{Gradient or slope of road: -0.06, -0.04, -0.02, 0.00, 0.02. 0.04 or 0.06}

\item{l}{Load of the vehicle: 0.0, 0.5 or 1.0}

\item{p}{Character; pollutant: "CO", "FC", "NOx", "NO", "NO2", "HC", "PM", "NMHC", "CH4",
"CO2",  "SO2" or "Pb". Only when p is "SO2" pr "Pb" x is needed. Also
polycyclic aromatic hydrocarbons (PAHs), persistent organi pollutants (POPs),
and Number of particles and Active Surface.}

\item{k}{Multiplication factor}

\item{show.equation}{Option to see or not the equation parameters}

\item{speed}{Numeric; Speed to return Number of emission factor and not a function.
It needs units in km/h}

\item{fcorr}{Numeric; Correction by fuel properties by euro technology.
See \code{\link{fuel_corr}}. The order from first to last is
"PRE", "I", "II", "III", "IV", "V", VI, "VIc". Default is 1}
}
\value{
an emission factor function which depends of the average speed V  g/km
}
\description{
This function returns speed dependent emission factors. The emission factors
comes from the guidelines  EMEP/EEA air pollutant emission inventory guidebook
http://www.eea.europa.eu/themes/air/emep-eea-air-pollutant-emission-inventory-guidebook
}
\note{
\strong{Pollutants (g/km)}: "CO", "NOx", "HC", "PM", "CH4", "NMHC", "CO2", "SO2",
"Pb".

\strong{Black Carbon and Organic Matter (g/km)}: "BC", "OM"

\strong{PAH and POP (g/km)}: "indeno(1,2,3-cd)pyrene", "benzo(k)fluoranthene",
"benzo(ghi)perylene", "fluoranthene",
"benzo(a)pyrene", "pyrene", "perylene",  "anthanthrene", "benzo(b)fluorene",
"benzo(e)pyrene", "triphenylene", "3,6-dimethyl-phenanthrene",
"benzo(a)anthracene",  "phenanthrene", "napthalene",  "anthracene"

\strong{Dioxins and furans (g equivalent toxicity / km)}: "PCDD", "PCDF" and "PCB".

\strong{Metals (g/km)}: "As", "Cd", "Cr", "Cu", "Hg", "Ni", "Pb", "Se", "Zn" (g/km).

\strong{NMHC (g/km)}: \code{\link{speciate}}

\emph{Active Surface (cm2/km) (gr = 0 and l = 0.5)}: "AS_urban", "AS_rural", "AS_highway"

\emph{Total Number of particles (N/km) (gr = 0 and l = 0.5)}: "N_urban", "N_rural", "N_highway",
"N_50nm_urban", "N_50_100nm_rural", "N_100_1000nm_highway".

The available standards for Active Surface or number of particles are:
Euro II and III
Euro II and III + CRDPF
Euro II and III + SCR
Euro IV + CRDPF
Euro V + SCR

The categories Pre Euro and Euro I were assigned with the factors of Euro II and Euro III
The categories euro IV and euro V were assigned with euro III + SCR
}
\examples{
\dontrun{
# Quick view
pol <- c("CO", "NOx", "HC", "NMHC", "CH4", "FC", "PM", "CO2", "SO2",
"AS_urban", "AS_rural", "AS_highway",
"N_urban", "N_rural", "N_highway",
"N_50nm_urban", "N_50_100nm_rural", "N_100_1000nm_highway")
f <- sapply(1:length(pol), function(i){
print(pol[i])
ef_hdv_speed(v = "Trucks",t = "RT", g = "<=7.5", e = "II", gr = 0,
l = 0.5, p = pol[i], x = 10)(30)
})
f
# PAH POP
ef_hdv_speed(v = "Trucks",t = "RT", g = "<=7.5", e = "II", gr = 0,
l = 0.5, p = "napthalene", x = 10)(30)
ef_hdv_speed(v = "Trucks",t = "RT", g = "<=7.5", e = "II", gr = 0,
l = 0.5, p = "fluoranthene", x = 10)(30)

# Dioxins and Furans
ef_hdv_speed(v = "Trucks",t = "RT", g = "<=7.5", e = "II", gr = 0,
l = 0.5, p = "PCB", x = 10)(30)

# NMHC
ef_hdv_speed(v = "Trucks",t = "RT", g = "<=7.5", e = "II", gr = 0,
l = 0.5, p = "heptane", x = 10)(30)

V <- 0:130
ef1 <- ef_hdv_speed(v = "Trucks",t = "RT", g = "<=7.5", e = "II", gr = 0,
l = 0.5, p = "HC")
plot(1:130, ef1(1:130), pch = 16, type = "b")
euro <- c(rep("V", 5), rep("IV", 5), rep("III", 5), rep("II", 5),
          rep("I", 5), rep("PRE", 15))
lef <- lapply(1:30, function(i) {
ef_hdv_speed(v = "Trucks", t = "RT", g = ">32", gr = 0,
eu = euro[i], l = 0.5, p = "NOx",
show.equation = FALSE)(25) })
efs <- EmissionFactors(unlist(lef)) #returns 'units'
plot(efs, xlab = "age")
lines(efs, type = "l")
a <- ef_hdv_speed(v = "Trucks", t = "RT", g = ">32", gr = 0,
eu = euro, l = 0.5, p = "NOx", speed = Speed(0:125))
a$speed <- NULL
filled.contour(as.matrix(a), col = cptcity::lucky(n = 24),
xlab = "Speed", ylab = "Age")
persp(x = as.matrix(a), theta = 35, xlab = "Speed", ylab = "Age",
zlab = "NOx [g/km]", col = cptcity::lucky(), phi = 25)
aa <- ef_hdv_speed(v = "Trucks", t = "RT", g = ">32", gr = 0,
eu = rbind(euro, euro), l = 0.5, p = "NOx", speed = Speed(0:125))
}
}
\seealso{
\code{\link{fuel_corr}} \code{\link{emis}} \code{\link{ef_ldv_cold}}
}
\keyword{emission}
\keyword{factors}
\keyword{speed}
